% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.multi.daily}
\alias{f.multi.daily}
\title{Creates an Multi-Day Frequency}
\usage{
f.multi.daily(year, month, day, k, dateString = NULL, asDateFun = NULL)
}
\arguments{
\item{year}{Year of the observation. It should be a valid year as an integer.}

\item{month}{Month of the observation. It should be a valid month of year as an integer.}

\item{day}{Day of the observation. It should be a valid day of month as an integer.}

\item{k}{Number of days.}

\item{dateString}{A string that represents a date. If not \code{NULL}, this will be used instead of \code{year}, \code{month}, and \code{day}, and they can be omitted.}

\item{asDateFun}{If \code{dateString} is given, you can use it to convert the string to a \code{Date}. If \code{NULL}, default conversion is used.}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{year} \tab Determines the \code{year}.\cr
\code{month} \tab Determines the \code{month}.\cr
\code{day} \tab Determines the \code{day}.\cr
\code{k} \tab Determines the value: \code{k}.
}
}
\description{
Use it to create a frequency for time-series data that occurs every \code{k} days. The first day of the interval is used as the reference.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} First day of the interval in \code{"YYYYMMDD"} format.
\item \strong{Class Id} \code{"d#"} (the number is value: \code{k}; e.g., d3 means every 3 days)
}
}
\examples{

md0 <- f.multi.daily(2023, 1, 2, 4) # This is 2/1/2023. Next observation belongs to 6/1/2023.

md0_value_str <-  as.character(md0) # this will be '20230102'.
md0_class_str <- get.class.id(md0) # this will be 'd4'.

md_new <- as.frequency("20230109", "d") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
md_invalid <- try(as.frequency("1399109", "d3")) # this is a too old date and unsupported
md_invalid <- try(as.frequency("20230132", "d4")) # invalid day in month
md_invalid <- try(as.frequency("20231331", "d5")) # invalid month
}

}
