% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc6.R
\name{mc6}
\alias{mc6}
\title{Perform level 6  
multiple-concentration processing}
\usage{
mc6(ae, wr = FALSE)
}
\arguments{
\item{ae}{Integer of length 1, assay endpoint id (aeid) for processing.}

\item{wr}{Logical, whether the processed data should be written to the tcpl
database}
}
\value{
A boolean of length 1, indicating the success of the processing, or 
when 'wr' is FALSE, a list where the first element is a boolean indiciating 
the success of processing and the second element is a data.table containing 
the processed data
}
\description{
\code{mc6} loads level 5 data from the tcpl 
database for the given id and performs level 6 
multiple-concentration processing. 
The processed data is then loaded into the mc6 table and 
all subsequent data is deleted with \code{\link{tcplCascade}}. See details 
for more information.

The individual processing functions are no longer exported, as it is 
typically more convenient and suggested to use the \code{\link{tcplRun}} 
wrapper function.
}
\details{
Level 6 multiple-concentration flagging uses both the plate level 
concentration-response data and the modeled parameters to flag potential 
false positives and false negative results.
}
\seealso{
\code{\link{Method functions}}, \code{\link{MC6_Methods}}

Other multiple-concentration data 
processing functions: \code{\link{mc1}},
  \code{\link{mc2}}, \code{\link{mc3}}, \code{\link{mc4}},
  \code{\link{mc5}}
}
\concept{multiple-concentration data 
processing functions}
