% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dataproc.R
\name{get.n.barcodes}
\alias{get.n.barcodes}
\title{Resample data frame using values from the column with number of clonesets.}
\usage{
get.n.barcodes(.data, .n = -1, .col = "Umi.count")
}
\arguments{
\item{.data}{Data frame with the column \code{.col} or list of such data frames.}

\item{.n}{Number of values / reads / UMIs to choose.}

\item{.col}{Which column choose to compute probabilities of getting a row. See "Details".}
}
\value{
Data frame with \code{sum(.data[, .col]) == .n}.
}
\description{
Resample data frame using values from the column with number of clonesets. Number of clonestes (i.e., rows of a MiTCR data frame)
are reads (usually the "Read.count" column) or UMIs (i.e., barcodes, usually the "Umi.count" column).
}
\details{
Using multinomial distribution, compute the number of occurences for each cloneset, than remove zero-number clonotypes and
return resulting data frame. Probabilities for \code{rmultinom} for each cloneset is a percentage of this cloneset in
the \code{.col} column.
}
\examples{
\dontrun{
# Get 100K reads (not clones!).
immdata.1.100k <- get.n.barcodes(immdata[[1]], 100000, .col = "Read.count")
}
}
\seealso{
\link{rmultinom}
}

