% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stats.R
\name{clonal.space.homeostasis}
\alias{clonal.space.homeostasis}
\title{Clonal space homeostasis.}
\usage{
clonal.space.homeostasis(.data, .clone.types = c(Rare = 1e-05, Small = 1e-04,
  Medium = 0.001, Large = 0.01, Hyperexpanded = 1),
  .prop.col = "Read.proportion")
}
\arguments{
\item{.data}{Cloneset data frame or list with such data frames.}

\item{.clone.types}{Named numeric vector.}

\item{.prop.col}{Which column to use for counting proportions.}
}
\description{
Compute clonal space homeostatsis - statistics of how many space occupied by clones
with specific proportions.
}
\examples{
\dontrun{
data(twb)
# Compute summary space of clones, that occupy
# [0, .05) and [.05, 1] proportion.
clonal.space.homeostasis(twb, c(Low = .05, High = 1)))
#        Low (0 < X <= 0.05) High (0.05 < X <= 1)
# Subj.A           0.9421980           0.05780198
# Subj.B           0.9239454           0.07605463
# Subj.C           0.8279270           0.17207296
# Subj.D           1.0000000           0.00000000
# I.e., for Subj.D sum of all read proportions for clones
# which have read proportion between 0 and .05 is equal to 1.
}
}
\seealso{
\link{vis.clonal.space}
}

