% Generated by roxygen2 (4.0.2): do not edit by hand
\name{parse.file.list}
\alias{parse.file.list}
\title{Parse files from the given vector or list with filepaths
and return list with data.frames.}
\usage{
parse.file.list(.filenames, .barcode.flag = F)
}
\arguments{
\item{.filenames}{Vector or list with paths to files with TCR data.}

\item{.barcode.flag}{If T than load MiTCR data.frames with new column Barcode.count
and without column Min.quality.}
}
\value{
List with data frame for the each name in the given filepaths.
}
\description{
Given the vector or list with filepaths, parse each file to a data frame
and combine them in a list. List items have names similar to names in the
given vector if filenames.
}
\examples{
\dontrun{
# Parse files "~/data/immdata1.txt" and "~/data/immdat2.txt".
immdata12 <- parse.file.list(c("~/data/immdata1.txt", "~/data/immdata2.txt"))
}
}
\seealso{
\link{parse.file}, \link{parse.folder}
}

