% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_workbook.R
\name{write_worksheet}
\alias{write_worksheet}
\alias{write_worksheet.Tagged_table}
\alias{write_worksheet.Composite_table}
\alias{write_worksheet.Mashed_table}
\alias{write_worksheet.Stacked_table}
\title{Write data to an openxlsx Worksheet}
\usage{
write_worksheet(dat, wb, sheet, append = FALSE, start_row = 1L, ...)

\method{write_worksheet}{Tagged_table}(dat, wb,
  sheet = sanitize_excel_sheet_names(attr(dat, "meta")$table_id),
  append = FALSE, start_row = 1L, ...)

\method{write_worksheet}{Composite_table}(dat, wb, sheet, append = FALSE,
  start_row = 1L, ...)

\method{write_worksheet}{Mashed_table}(dat, wb, sheet, append = FALSE,
  start_row = 1L, mash_method = attr(dat, "mash_method"),
  id_vars = attr(dat, "id_vars"), insert_blank_row = attr(dat,
  "insert_blank_row"), sep_height = attr(dat, "sep_height"), ...)

\method{write_worksheet}{Stacked_table}(dat, wb, sheet, append = FALSE,
  start_row = 1L, spacing = attr(dat, "spacing"), ...)
}
\arguments{
\item{dat}{A \link{Tatoo_table}.}

\item{wb}{A \link{openxlsx} Workbook object}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{append}{Logical. Whether or not to append to an exisiting worksheet or
create a new one}

\item{start_row}{A scalar specifiying the starting row to write to.}

\item{...}{additional options that can be used override the styling
attributes of the \link{Tatoo_table} you want to export.}

\item{mash_method}{either \code{"row"} or \code{"col"}. should the tables be mashed by
row or by column?}

\item{id_vars}{If id_vars is specified, the tables will be combined
using \code{\link[=merge]{merge()}} on the columns specified in id_vars, otherwise
the tables will be combined with \code{\link[=cbind]{cbind()}}.}

\item{insert_blank_row}{Only if mashing rows: logical. Whether to insert
blank rows between mash-groups. \emph{Warning: this converts all columns to
character.} Use with care.}

\item{sep_height}{Only has an effect when exporting to \code{xlsx}. if
\code{insert_blank_row == TRUE}, hight of the inserted row, else height of the
top row of each mash-group.}

\item{spacing}{Number of lineskips between the tables when exporting to
xlsx}
}
\value{
an \link{openxlsx} Workbook object
}
\description{
This function is similar to \code{\link[openxlsx:writeData]{openxlsx::writeData()}} from the
\link{openxlsx} package, but rather than just writing data.frames,
`write_worksheet`` supports specialised methods for the various
\link{Tatoo_table} subclasses.
}
\seealso{
Other xlsx exporters: \code{\link{as_workbook}}
}
