% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_manifest.R
\name{tar_manifest}
\alias{tar_manifest}
\title{Produce a data frame of information about your targets.}
\usage{
tar_manifest(
  names = NULL,
  fields = c("name", "command", "pattern"),
  callr_function = callr::r,
  callr_arguments = targets::callr_args_default(callr_function),
  envir = parent.frame(),
  script = targets::tar_config_get("script")
)
}
\arguments{
\item{names}{Names of the targets to show. Set to \code{NULL} to
show all the targets (default). Otherwise, you can supply
symbols, a character vector, or \code{tidyselect} helpers like
\code{\link[=all_of]{all_of()}} and \code{\link[=starts_with]{starts_with()}}.}

\item{fields}{Names of the fields, or columns, to show. Set to \code{NULL} to
show all the fields (default). Otherwise, you can supply
symbols, a character vector, or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.
Set to \code{NULL} to print all the fields.
The name of the target is always included as the first column
regardless of the selection.
Possible fields are below. All of them can be set in \code{\link[=tar_target]{tar_target()}},
\code{\link[=tar_target_raw]{tar_target_raw()}}, or \code{\link[=tar_option_set]{tar_option_set()}}.
\itemize{
\item \code{name}: Name of the target.
\item \code{command}: the R command that runs when the target builds.
\item \code{pattern}: branching pattern of the target, if applicable.
\item \code{format}: Storage format.
\item \code{iteration}: Iteration mode for branching.
\item \code{error}: Error mode, what to do when the target fails.
\item \code{memory}: Memory mode, when to keep targets in memory.
\item \code{storage}: Storage mode for high-performance computing scenarios.
\item \code{retrieval}: Retrieval mode for high-performance computing scenarios.
\item \code{deployment}: Where/whether to deploy the target in high-performance
computing scenarios.
\item \code{priority}: Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[=tar_make_future]{tar_make_future()}}).
\item \code{resources}: A list of target-specific resource requirements for
\code{\link[=tar_make_future]{tar_make_future()}}.
\item \code{cue_mode}: Cue mode from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_depend}: Depend cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_expr}: Command cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_file}: File cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_format}: Format cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{cue_iteration}: Iteration cue from \code{\link[=tar_cue]{tar_cue()}}.
\item \code{packages}: List columns of packages loaded before building the target.
\item \code{library}: List column of library paths to load the packages.
}}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}
}
\value{
A data frame of information about the targets in the pipeline.
Rows appear in topological order (the order they will run
without any influence from parallel computing or priorities).
}
\description{
Along with \code{\link[=tar_visnetwork]{tar_visnetwork()}} and \code{\link[=tar_glimpse]{tar_glimpse()}},
\code{tar_manifest()} helps check that you constructed your pipeline correctly.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set()
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2),
    tar_target(m, z, pattern = map(z)),
    tar_target(c, z, pattern = cross(z))
  )
}, ask = FALSE)
tar_manifest()
tar_manifest(fields = c("name", "command"))
tar_manifest(fields = "command")
tar_manifest(fields = starts_with("cue"))
})
}
}
\seealso{
Other inspect: 
\code{\link{tar_deps_raw}()},
\code{\link{tar_deps}()},
\code{\link{tar_glimpse}()},
\code{\link{tar_network}()},
\code{\link{tar_outdated}()},
\code{\link{tar_sitrep}()},
\code{\link{tar_validate}()},
\code{\link{tar_visnetwork}()}
}
\concept{inspect}
