% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_load_everything.R
\name{tar_load_everything}
\alias{tar_load_everything}
\title{Load the values of all available targets.}
\usage{
tar_load_everything(
  branches = NULL,
  meta = tar_meta(targets_only = TRUE, store = store),
  strict = TRUE,
  silent = FALSE,
  envir = parent.frame(),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{branches}{Integer of indices of the branches to load
for any targets that are patterns.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}

\item{strict}{Logical of length 1, whether to error out
if one of the selected targets is in the metadata
but cannot be loaded.
Set to \code{FALSE} to just load the targets in the metadata
that can be loaded and skip the others.}

\item{silent}{Logical of length 1. Only relevant when
\code{strict} is \code{FALSE}. If \code{silent} is \code{FALSE}
and \code{strict} is \code{FALSE}, then a message will be printed
if a target is in the metadata but cannot be loaded.
However, load failures
will not stop other targets from being loaded.}

\item{envir}{Environment to put the loaded targets.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Nothing.
}
\description{
Shorthand for \code{tar_load(everything())} to load all
targets with entries in the metadata.
}
\section{Limited scope}{

\code{tar_read()} and \code{tar_load()}
are only for exploratory analysis and literate programming,
and \code{tar_read_raw()} and \code{tar_load_raw()} are only
for exploratory analysis. \code{targets} automatically
loads the correct dependencies into memory when the pipeline
is running, so invoking these functions
from inside a target is rarely advisable.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
ls() # Does not have "y1", "y2", or "z".
tar_load_everything()
ls() # Has "y1", "y2", and "z".
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
