% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-operators.R
\name{col_header}
\alias{col_header}
\alias{row_header}
\alias{write_cell}
\alias{home}
\alias{cursor_up}
\alias{cursor_down}
\alias{cursor_left}
\alias{cursor_right}
\alias{cursor_pos}
\alias{carriage_return}
\alias{line_feed}
\alias{new_line}
\alias{new_row}
\alias{new_col}
\alias{table_apply}
\alias{add_col}
\alias{add_row}
\alias{set_footnote}
\alias{set_id}
\alias{set_caption}
\alias{set_style}
\alias{set_colspan}
\alias{set_rowspan}
\title{A set of magrittr operators for tangram tables}
\usage{
col_header(table, ..., sub = TRUE)

row_header(table, ..., sub = TRUE)

write_cell(table, x, ...)

home(table)

cursor_up(table, n = 1)

cursor_down(table, n = 1)

cursor_left(table, n = 1)

cursor_right(table, n = 1)

cursor_pos(table, nrow, ncol)

carriage_return(table)

line_feed(table, n = 1)

new_line(table)

new_row(table)

new_col(table)

table_apply(table, x, FUN, ...)

add_col(table, ...)

add_row(table, ...)

set_footnote(table, footnote)

set_id(table, id)

set_caption(table, caption)

set_style(table, style)

set_colspan(table, span)

set_rowspan(table, span)
}
\arguments{
\item{table}{tangram; The tangram table being built}

\item{...}{additional argument passed}

\item{sub}{logical; Is this a subheader}

\item{x}{object of focus in operation}

\item{n}{numeric; number of times to perform operation}

\item{nrow}{numeric; number of rows}

\item{ncol}{numeric; number of columns}

\item{FUN}{function; function to apply}

\item{footnote}{character; footnote to add}

\item{id}{character; id of table}

\item{caption}{character; caption of table}

\item{style}{character; styling in compiling table and in rendering}

\item{span}{numeric; number of rows or columns to span}
}
\description{
A set of magrittr operators for tangram tables
}
