% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-rmd.R
\name{rmd}
\alias{rmd}
\alias{rmd.default}
\alias{rmd.cell}
\alias{rmd.cell_iqr}
\alias{rmd.cell_estimate}
\alias{rmd.cell_fstat}
\alias{rmd.cell_fraction}
\alias{rmd.cell_chi2}
\alias{rmd.cell_studentt}
\alias{rmd.cell_spearman}
\alias{rmd.cell_n}
\alias{rmd.tangram}
\alias{rmd.table_builder}
\title{Generate an Rmd table entry from a cell object}
\usage{
rmd(object, key = FALSE, ...)

\method{rmd}{default}(object, key = FALSE, ...)

\method{rmd}{cell}(object, key = FALSE, ...)

\method{rmd}{cell_iqr}(object, key = FALSE, ...)

\method{rmd}{cell_estimate}(object, key = FALSE, ...)

\method{rmd}{cell_fstat}(object, key = FALSE, ...)

\method{rmd}{cell_fraction}(object, key = FALSE, ...)

\method{rmd}{cell_chi2}(object, key = FALSE, ...)

\method{rmd}{cell_studentt}(object, key = FALSE, ...)

\method{rmd}{cell_spearman}(object, key = FALSE, ...)

\method{rmd}{cell_n}(object, key = FALSE, ...)

\method{rmd}{tangram}(object, key = NULL, append = FALSE, ...)

\method{rmd}{table_builder}(object, key = FALSE, ...)
}
\arguments{
\item{object}{The cell_fstat for indexing}

\item{key}{A filename to write key values into. Can be false if no key file is desired.}

\item{...}{additional arguments to renderer. Unused}

\item{append}{logical; Should the key file be appended too, or overwritten}
}
\value{
A string representation of the table
}
\description{
Given a cell object generate the corresponding piece of an Rmd table
}
\examples{
 rmd(tangram(drug ~ bili, pbc))
}
