% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothloess.R
\name{smooth.loess}
\alias{smooth.loess}
\title{Title smooth.loess}
\usage{
smooth.loess(x, y, safe.start = 5, safe.end = 5, myspan = 0.28)
}
\arguments{
\item{x}{variable x}

\item{y}{variable y}

\item{safe.start}{exclude a the n-th first values from calculation}

\item{safe.end}{exclude a the n-th end values from calculation}

\item{myspan}{span parameter for loess function}
}
\description{
a wrapper for the loess function included in the R base system
}
\examples{
npoints=1000
x=seq(1,npoints)
y=(dnorm(x, mean=npoints/2, sd=npoints/10))
y.smooth=smooth.loess(x,y)
plot(x,y)

}
