% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_classes.R
\name{kable_tabxplor_style}
\alias{kable_tabxplor_style}
\title{Print a tabxplor table in html}
\usage{
kable_tabxplor_style(
  tabs,
  caption = knitr::opts_current$get("tab.cap"),
  theme = c("light", "dark"),
  total_in_bold = TRUE,
  all_column_borders = FALSE,
  html_font = NULL,
  full_width = FALSE,
  wrap_rows = 35,
  wrap_cols = 15,
  whitespace_only = TRUE,
  subtext = "",
  ...
)
}
\arguments{
\item{tabs}{A data.frame.}

\item{caption}{The table caption. For formatting, you need to use a \code{css}
with \verb{caption\{\}}in rmarkdown.}

\item{theme}{By default, a white table with black text, Set to \code{"dark"} for a
black table with white text.}

\item{total_in_bold}{Should rows and cols with "Total" string be set in bold ?}

\item{all_column_borders}{Put a vertical border around each column ?}

\item{html_font}{A string for HTML css font. By default, it uses
\code{'"DejaVu Sans", "Arial", arial, helvetica, sans-serif'}. Set another
default by setting \code{options("tabxplor.kable_html_font" = )}.}

\item{full_width}{A TRUE or FALSE variable controlling whether the HTML table
should have the preferable format for full_width. If not specified, a HTML
table will have full width by default but this option will be set to FALSE for
a LaTeX table.}

\item{wrap_rows}{By default, rownames are wrapped when larger than 30 characters.}

\item{wrap_cols}{By default, colnames are wrapped when larger than 12 characters.}

\item{whitespace_only}{Set to \code{FALSE} to wrap also on non whitespace characters.}

\item{subtext}{A character vector to print rows of legend under the table.}

\item{...}{Other arguments to pass to \code{\link[kableExtra:kable_styling]{kableExtra::kable_styling}}.}
}
\value{
A html table (opened in the viewer in RStudio). Differences from totals,
confidence intervals, contribution to variance, and unweighted counts,
are available in an html tooltip at cells hover.
}
\description{
Print a tabxplor table in html
}
\examples{
\donttest{
tabs <- tibble::tibble(nm      = c("First", "Second", "Total"),
                       column1 = c(1, 2, 3),
                       column2 = c(4, 5, 6)                    )
kable_tabxplor_style(tabs)
}
}
