% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmvtab.h.R
\name{jmvtab}
\alias{jmvtab}
\title{Crosstables}
\usage{
jmvtab(
  data,
  row_vars = NULL,
  col_vars = NULL,
  tab_vars = NULL,
  wt = NULL,
  pct = "no",
  color = "no",
  chi2 = TRUE,
  OR = "no",
  na = "keep",
  lvs = "all",
  other_if_less_than = 0,
  cleannames = TRUE,
  ref = "auto",
  ref2 = "first",
  comp = "tab",
  ci = "auto",
  conf_level = 0.95,
  ci_print = "ci",
  totaltab = "line",
  wrap_rows = 35,
  wrap_cols = 15,
  display = "auto",
  add_n = TRUE,
  add_pct = FALSE,
  subtext = "",
  digits = 0
)
}
\arguments{
\item{data}{A data.frame.}

\item{row_vars}{The row variable, which will be printed with one level per
line. If numeric, it will be converted to factor.}

\item{col_vars}{One column is printed for each level of each column
variable. For numeric variables means are calculated, in a single column.}

\item{tab_vars}{One subtable is made for each combination of levels of the
tab variables. All tab variables are converted to factor. Leave empty to
make a simple table.}

\item{wt}{A weight variable, of class numeric. Leave empty for unweighted
results.}

\item{pct}{The type of percentages to calculate :  \itemize{    \item
\code{"row"}: row percentages.    \item \code{"col"}: column percentages.
\item \code{"all"}: frequencies for each subtable/group, if there is
\code{tab_vars}.    \item \code{"all_tabs"}: frequencies for the whole (set
of) table(s).  }}

\item{color}{The type of colors to print, as a single string. Vectorised
over \code{row_vars}.  \itemize{    \item \code{"no"}: by default, no
colors are printed.    \item \code{"diff"}: color percentages and means
based on cells differences from    totals (or from first cells when
\code{ref = "first"}).    \item \code{"diff_ci"}: color pct and means based
on cells differences from totals    or first cells, removing coloring when
the confidence interval of this difference    is higher than the difference
itself.    \item \code{"after_ci"}: idem, but cut off the confidence
interval from the    difference first.    \item \code{"contrib"}: color
cells based on their contribution to variance    (except mean columns, from
numeric variables).    \item \code{"OR"}: for \code{pct == "col"} or
\code{pct == "row"},    color based on odds ratios (or relative risks
ratios)  }}

\item{chi2}{Set to \code{TRUE} to make a Chi2 and add summary stats. Also
useful to color cells based on their contribution to variance.}

\item{OR}{With \code{pct = "row"} or \code{pct = "col"}, calculate and
print odds ratios  (for binary variables) or relative risks ratios (for
variables with 3 levels  or more). \itemize{  \item \code{"no"}: by
default, no OR are calculated.  \item \code{"OR"}: print OR (instead of
percentages).  \item \code{"OR_pct"}: print OR, with percentages in
bracket. }}

\item{na}{The policy to adopt with missing values. It must be a single
string.  \itemize{    \item \code{na = "keep"}: by default, prints
\code{NA}'s as explicit \code{"NA"} level.    \item \code{na = "drop"}:
removes \code{NA} levels before making each table    (tabs made with
different column variables may have a different number of    observations,
and won't exactly have the same total columns).    }}

\item{lvs}{The levels of \code{col_vars} to keep.  \itemize{    \item
\code{"all"}: by default, all levels are kept.    \item \code{"first"}:
only keep the first level of each \code{col_vars}    \item \code{"auto"}:
keep the first level when \code{col_var} is only two levels,    keep all
levels otherwise.    }}

\item{other_if_less_than}{When set to a positive integer, levels with less
count than that will be merged into an "Others" level.}

\item{cleannames}{By default, clean levels names, by removing prefix
numbers like "1-", and text in parenthesis. Set to \code{FALSE} to avoid
this behaviour.}

\item{ref}{The reference cell to calculate differences and ratios   (used
to print \code{colors}) :   \itemize{    \item \code{"auto"}: by default,
cell difference from the corresponding total    (rows or cols depending on
\code{pct = "row"} or \code{pct = "col"}) is    used for \code{diff} ; cell
ratio from the first line (or col) is use for \code{OR}    (odds
ratio/relative risks ratio).    \item \code{"tot"}: totals are always used.
\item \code{"first"}: calculate cell difference or ratio from the first
cell  of the row or column (useful to color temporal developments).
\item \code{n}: when \code{ref} is an integer, the nth row (or column) is
used for comparison.    \item \code{"regex"}: when \code{ref} is a string,
it it used as a regular expression,    to match with the names of the rows
(or columns). Be precise enough to match only one    column or row,
otherwise you get a warning message.    \item \code{"no"}: not use ref and
not calculate diffs to gain calculation time.  }}

\item{ref2}{A second reference cell is needed to calculate odds ratios  (or
relative risks ratios). The first cell of the row or column is used by
default.  See \code{ref}  for the full list of possible values.}

\item{comp}{The comparison level : by subtables/groups, or for the whole
table.}

\item{ci}{The type of confidence intervals to calculate, passed to
\code{\link{tab_ci}}.     \itemize{      \item \code{"cell"}: absolute
confidence intervals of cells percentages.      \item \code{"diff"}:
confidence intervals of the difference between a cell and the      relative
total cell (or relative first cell when \code{ref = "first"}).      \item
\code{"auto"}: \code{ci = "diff"} for means and row/col percentages,
\code{ci = "cell"} for frequencies ("all", "all_tabs").     } By default,
for percentages, with \code{ci = "cell"} Wilson's method is used, and with
\code{ci = "diff"} Wald's method along Agresti and Caffo's adjustment.
Means use classic method.}

\item{conf_level}{The confidence level, as a single numeric between 0 and
\enumerate{
\item Default to 0.95 (95\\%).
}}

\item{ci_print}{By default confidence interval are printed with the
interval display. Set to "moe" to use pct +- moe instead.}

\item{totaltab}{The total table, if there are subtables/groups   (i.e. when
\code{tab_vars} is provided). Vectorised over \code{row_vars}.  \itemize{
\item \code{"line"}: by default, add a general total line (necessary for
calculations with \code{comp = "all"})    \item \code{"table"}: add a
complete total table   (i.e. \code{row_var} by \code{col_vars} without
\code{tab_vars}).    \item \code{"no"}: not to draw any total table.   }}

\item{wrap_rows}{By default, rownames are wrapped when larger than 30
characters.}

\item{wrap_cols}{By default, colnames are wrapped when larger than 12
characters.}

\item{display}{The information to display in the table.}

\item{add_n}{For \code{pct = "row"} or \code{pct = "col"}, set to
\code{FALSE} not to add another column or row with unweighted counts
(\code{n}).}

\item{add_pct}{Set to \code{TRUE} to add a column with the frequencies of
the row variable (for \code{pct = "row"}) or a row with the frequencies of
the column variable (for  \code{pct = "col"})}

\item{subtext}{A character vector to print rows of legend under the table.}

\item{digits}{The number of digits to print, as a single integer, or an
integer vector the same length as \code{col_vars}.}
}
\value{
A results object containing:
\tabular{llllll}{
\code{results$html_table} \tab \tab \tab \tab \tab a html \cr
\code{results$chi2_table} \tab \tab \tab \tab \tab a table \cr
\code{results$plot} \tab \tab \tab \tab \tab an image \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$chi2_table$asDF}

\code{as.data.frame(results$chi2_table)}
}
\description{
Crosstables
}
