% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/beta-diversity.R
\docType{methods}
\name{beta-diversity}
\alias{beta-diversity}
\alias{turnover}
\alias{turnover-method}
\alias{similarity}
\alias{similarity-method}
\alias{turnover,CountMatrix-method}
\alias{turnover,IncidenceMatrix-method}
\alias{similarity,CountMatrix-method}
\alias{similarity,IncidenceMatrix-method}
\title{\eqn{\beta}{\beta}-diversity}
\usage{
turnover(object, ...)

similarity(object, ...)

\S4method{turnover}{CountMatrix}(object, method = c("whittaker", "cody",
  "routledge1", "routledge2", "routledge3", "wilson"), simplify = FALSE,
  ...)

\S4method{turnover}{IncidenceMatrix}(object, method = c("whittaker",
  "cody", "routledge1", "routledge2", "routledge3", "wilson"),
  simplify = FALSE, ...)

\S4method{similarity}{CountMatrix}(object, method = c("brainerd", "bray",
  "jaccard", "morisita", "sorenson"), ...)

\S4method{similarity}{IncidenceMatrix}(object, method = c("jaccard",
  "sorenson"), ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments passed to other methods.}

\item{method}{A \code{\link{character}} string specifiying the method to be
used (see details). Any unambiguous substring can be given.}

\item{simplify}{A \code{\link{logical}} scalar: should the result be
simplified to a matrix? The default value, \code{FALSE}, returns a list.}
}
\value{
\code{similarity} returns a \eqn{m \times m}{m x m} symetric matrix.

 If \code{simplify} is \code{FALSE}, \code{turnover} returns a list
 (default), else returns a matrix.
}
\description{
Measures differenciation diversity. \code{similarity} returns a similarity
 matrix. \code{turnover} returns the degree of turnover in taxa composition
 along a grandient or transect.
}
\section{Turnover}{

 The following methods can be used to acertain the degree of \emph{turnover}
 in taxa composition along a gradient (\eqn{\beta}-diversity) on qualitative
 (presence/absence) data. This assumes that the order of the matrix rows
 (from 1 to \eqn{n}) follows the progression along the gradient/transect.

 \describe{
  \item{whittaker}{Whittaker measure.}
  \item{cody}{Cody measure.}
  \item{routledge1}{Routledge first measure.}
  \item{routledge2}{Routledge second measure.}
  \item{routledge3}{Routledge third measure. This is the exponential form of
  the second measure.}
  \item{wilson}{Wilson measure.}
 }
}

\section{Similarity}{

 \eqn{\beta}-diversity can also be measured by addressing \emph{similarity}
 between pairs of sites. This provides a scale of similarity from
 \code{0}-\code{1} where \code{1} is perfect similarity and \code{0} is
 no similarity (with the exception of the Brainerd-Robinson index which is
 scaled between \code{0} and \code{200}):
 \describe{
  \item{brainerd}{Brainerd-Robinson quantitative index. This is a city-block
  metric of similarity.}
  \item{bray}{Sorenson quantitative index (Bray and Curtis modified version
  of the Sorenson index).}
  \item{jaccard}{Jaccard qualitative index.}
  \item{morisita}{Morisita-Horn quantitative index.}
  \item{sorenson}{Sorenson qualitative index.}
 }
}

\examples{
# Degree of turnover
# Data from Magurran 1988, p. 162
trees <- IncidenceMatrix(
  data = c(1, 1, 1, 0, 0, 0,
           1, 1, 1, 1, 1, 1,
           0, 0, 1, 0, 1, 0,
           0, 0, 0, 1, 1, 1,
           0, 0, 0, 0, 1, 1,
           0, 0, 0, 1, 0, 1),
  nrow = 6, byrow = FALSE,
  dimnames = list(c("1", "2", "3", "4", "5", "6"),
                  c("Birch", "Oak", "Rowan", "Beech", "Hazel", "Holly"))
)

## Whittaker's measure
turnover(trees, "whittaker") # 1

## Cody's measure
turnover(trees, "cody") # 3

## Routledge's measures
turnover(trees, "routledge1") # 0.29
turnover(trees, "routledge2") # 0.56
turnover(trees, "routledge3") # 1.75

## Wilson and Shmida's measure
turnover(trees, "wilson") # 1

# Similarity measures
# Data from Magurran 1988, p. 166
birds <- CountMatrix(
  data = c(1.4, 4.3, 2.9, 8.6, 4.2, 15.7, 2.0, 50, 1, 11.4, 11.4, 4.3, 13.0,
           14.3, 8.6, 7.1, 10.0, 1.4, 2.9, 5.7, 1.4, 11.4, 2.9, 4.3, 1.4, 2.9,
           0, 0, 0, 2.9, 0, 0, 0, 10, 0, 0, 5.7, 2.5, 5.7, 8.6, 5.7, 2.9, 0, 0,
           2.9, 0, 0, 5.7, 0, 2.9, 0, 2.9) * 10,
  nrow = 2, byrow = TRUE, dimnames = list(c("unmanaged", "managed"), NULL)
)

## Jaccard measure
## (presence/absence data)
similarity(birds, "jaccard") # 0.46

## Sorenson measure
## (presence/absence data)
similarity(birds, "sorenson") # 0.63

## Jaccard measure (Bray's formula)
## (count data)
similarity(birds, "bray") # 0.44

## Morisita-Horn measure
## (count data)
similarity(birds, "morisita") # 0.81
}
\references{
Brainerd, G. W. (1951). The Place of Chronological Ordering in
 Archaeological Analysis. \emph{American Antiquity}, 16(04), 301-313.
 DOI: \href{https://doi.org/10.2307/276979}{10.2307/276979}.

 Bray, J. R. & Curtis, J. T. (1957). An Ordination of the Upland Forest
 Communities of Southern Wisconsin. \emph{Ecological Monographs}, 27(4),
 325-349. DOI: \href{https://doi.org/10.2307/1942268}{10.2307/1942268}.

 Cody, M. L. (1975). Towards a theory of continental species diversity: Bird
 distributions over Mediterranean habitat gradients. \emph{In} M. L. Cody &
 J. M. Diamond (Eds.), \emph{Ecology and Evolution of Communities}.
 Cambridge, MA: Harvard University Press, p. 214–257.

 Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
 Princeton, NJ: Princeton University Press.
 DOI:\href{https://doi.org/10.1007/978-94-015-7358-0}{10.1007/978-94-015-7358-0}.

 Robinson, W. S. (1951). A Method for Chronologically Ordering Archaeological
 Deposits. \emph{American Antiquity}, 16(04), 293-301.
 DOI: \href{https://doi.org/10.2307/276978}{10.2307/276978}.

 Routledge, R. D. (1977). On Whittaker’s Components of Diversity.
 \emph{Ecology}, 58(5), 1120-1127.
 DOI: \href{https://doi.org/10.2307/1936932}{10.2307/1936932}.

 Whittaker, R. H. (1960). Vegetation of the Siskiyou Mountains, Oregon and
 California. \emph{Ecological Monographs}, 30(3), 279-338.
 DOI: \href{https://doi.org/10.2307/1943563}{10.2307/1943563}.

 Wilson, M. V., & Shmida, A. (1984). Measuring Beta Diversity with
 Presence-Absence Data. \emph{The Journal of Ecology}, 72(3), 1055-1064.
 DOI: \href{https://doi.org/10.2307/2259551}{10.2307/2259551}.
}
\seealso{
\code{\link[=alpha-diversity]{richness}}
 \code{\link[=alpha-diversity]{rarefaction}}
 \code{\link[=alpha-diversity]{diversity}}
 \code{\link[=alpha-diversity]{evenness}}
}
\author{
N. Frerebeau
}
