% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/NumericMatrix.R
\docType{class}
\name{CountMatrix-class}
\alias{CountMatrix-class}
\alias{CountMatrix}
\title{Count matrix}
\usage{
CountMatrix(data = NA, nrow = 1, ncol = 1, byrow = FALSE,
  dimnames = NULL)
}
\arguments{
\item{data}{an optional data vector (including a list or
    \code{\link{expression}} vector).  Non-atomic classed \R objects are
    coerced by \code{\link{as.vector}} and all attributes discarded.}

\item{nrow}{the desired number of rows.}

\item{ncol}{the desired number of columns.}

\item{byrow}{logical. If \code{FALSE} (the default) the matrix is
    filled by columns, otherwise the matrix is filled by rows.}

\item{dimnames}{A \code{\link{dimnames}} attribute for the matrix:
    \code{NULL} or a \code{list} of length 2 giving the row and column
    names respectively.  An empty list is treated as \code{NULL}, and a
    list of length one as row names.  The list can be named, and the
    list names will be used as names for the dimensions.}
}
\description{
An S4 class to represent a count matrix.
}
\details{
Numeric values are coerced to \code{\link{integer}} as by
 \code{\link[base]{as.integer}} (and hence truncated towards zero).
}
\note{
This class extends the \code{base} \link[base]{matrix}.
}
\examples{
# Create a count data matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE),
                  nrow = 10, ncol = 10, byrow = TRUE)

# Coerce counts to frequencies
B <- as(A1, "FrequencyMatrix")

# Row sums are internally stored before coercing to a frequency matrix
totals(B) # Get row sums

# This allows to restore the source data
A2 <- as(B, "CountMatrix")
all(A1 == A2)
}
\seealso{
\link[base]{matrix}

Other abundance matrix: \code{\link{FrequencyMatrix-class}}
}
\author{
N. Frerebeau
}
\concept{abundance matrix}
