% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_styles.R
\name{cell_style}
\alias{cell_style}
\title{cell_style}
\usage{
cell_style(rows, colnames, style, gridExpand = TRUE, stack = TRUE)
}
\arguments{
\item{rows}{indices of the rows to which the style should be applied}

\item{colnames}{names of the columns to which the style should be applied}

\item{style}{style created with openxlsx::createStyle() that will be applied to
the selected cells}

\item{gridExpand}{see ?openxlsx::addStyle: Apply style only to the selected
elements (set gridExpand = FALSE) or to all combinations?}

\item{stack}{should the style be added to existing styles (TRUE) or overwrite
existing styles (FALSE)}
}
\value{
list with specified styles
}
\description{
cell_style
}
\examples{
library(tablespan)
data("iris")

tbl <- tablespan(data = iris[iris$Species == "setosa", ],
          formula = Species ~ (Sepal = Sepal.Length + Sepal.Width) +
            (Petal = (Width = Petal.Length) + Petal.Width))


# To apply a custom style to some elements use the styles argument. The following
# applies the "bold" style to the rows 1-5 of the Sepal.Length column and
# the rows 9-10 of the Petal.Width column.
bold <- openxlsx::createStyle(textDecoration = "bold")

wb <- as_excel(tbl = tbl,
               styles = tbl_styles(cell_styles = list(cell_style(rows = 1:5,
                                                                colnames = "Sepal.Length",
                                                                style = bold),
                                                     cell_style(rows = 9:10,
                                                                colnames = "Petal.Width",
                                                                style = bold))))
# saveWorkbook(wb, "iris.xlsx")
}
