% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyCreateCatTable.R
\name{svyCreateCatTable}
\alias{svyCreateCatTable}
\title{Create an object summarizing categorical variables for weighted data}
\usage{
svyCreateCatTable(vars, strata, data, includeNA = FALSE, test = TRUE,
  testApprox = svyTestChisq, argsApprox = NULL, smd = TRUE)
}
\arguments{
\item{vars}{Variable(s) to be summarized given as a character vector.}

\item{strata}{Stratifying (grouping) variable name(s) given as a character vector. If omitted, the overall results are returned.}

\item{data}{A survey design object in which these variables exist. All variables (both vars and strata) must be in this survey design object. It is created with the \code{svydesign} function in the \code{survey} package.}

\item{includeNA}{If TRUE, NA is handled as a regular factor level rather than missing. NA is shown as the last factor level in the table. Only effective for categorical variables.}

\item{test}{If TRUE, as in the default and there are more than two groups, groupwise comparisons are performed. Both tests that require the large sample approximation and exact tests are performed. Either one of the result can be obtained from the print method.}

\item{testApprox}{A function used to perform the large sample approximation based tests. The default is \code{svychisq}.}

\item{argsApprox}{A named list of arguments passed to the function specified in testApprox.}

\item{smd}{If TRUE, as in the default and there are more than two groups, standardized mean differences for all pairwise comparisons are calculated.}
}
\value{
An object of class \code{svyCatTable}.
}
\description{
Create an object summarizing categorical variables optionally stratifying by one or more startifying variables and performing statistical tests. Usually, \code{\link{svyCreateTableOne}} should be used as the universal frontend for both continuous and categorical data.
}
\examples{

## See the examples for svyCreateTableOne()

}
\seealso{
\code{\link{svyCreateTableOne}}, \code{\link{print.svyCatTable}}, \code{\link{summary.svyCatTable}},
}
\author{
Kazuki Yoshida
}
