% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.TableOne.R
\name{print.TableOne}
\alias{print.TableOne}
\title{Format and print \code{TableOne} class objects}
\usage{
\method{print}{TableOne}(x, catDigits = 1, contDigits = 2, pDigits = 3,
  quote = FALSE, missing = FALSE, explain = TRUE, printToggle = TRUE,
  test = TRUE, smd = FALSE, noSpaces = FALSE, padColnames = FALSE,
  varLabels = FALSE, format = c("fp", "f", "p", "pf")[1],
  showAllLevels = FALSE, cramVars = NULL, dropEqual = FALSE,
  exact = NULL, nonnormal = NULL, minMax = FALSE, ...)
}
\arguments{
\item{x}{Object returned by \code{\link{CreateTableOne}} function.}

\item{catDigits}{Number of digits to print for proportions. Default 1.}

\item{contDigits}{Number of digits to print for continuous variables. Default 2.}

\item{pDigits}{Number of digits to print for p-values (also used for standardized mean differences). Default 3.}

\item{quote}{Whether to show everything in quotes. The default is FALSE. If TRUE, everything including the row and column names are quoted so that you can copy it to Excel easily.}

\item{missing}{Whether to show missing data information.}

\item{explain}{Whether to add explanation to the variable names, i.e., (\%) is added to the variable names when percentage is shown.}

\item{printToggle}{Whether to print the output. If FALSE, no output is created, and a matrix is invisibly returned.}

\item{test}{Whether to show p-values. TRUE by default. If FALSE, only the numerical summaries are shown.}

\item{smd}{Whether to show standardized mean differences. FALSE by default. If there are more than one contrasts, the average of all possible standardized mean differences is shown. For individual contrasts, use \code{summary}.}

\item{noSpaces}{Whether to remove spaces added for alignment. Use this option if you prefer to align numbers yourself in other software.}

\item{padColnames}{Whether to pad column names with spaces to center justify. The default is FALSE. It is not conducted if noSpaces = TRUE.}

\item{varLabels}{Whether to replace variable names with variable labels obtained from \code{labelled::var_label()} function.}

\item{format}{The default is "fp" frequency (percentage). You can also choose from "f" frequency only, "p" percentage only, and "pf" percentage (frequency).}

\item{showAllLevels}{Whether to show all levels. FALSE by default, i.e., for 2-level categorical variables, only the higher level is shown to avoid redundant information.}

\item{cramVars}{A character vector to specify the two-level categorical variables, for which both levels should be shown in one row.}

\item{dropEqual}{Whether to drop " = second level name" description indicating which level is shown for two-level categorical variables.}

\item{exact}{A character vector to specify the variables for which the p-values should be those of exact tests. By default all p-values are from large sample approximation tests (chisq.test).}

\item{nonnormal}{A character vector to specify the variables for which the p-values should be those of nonparametric tests. By default all p-values are from normal assumption-based tests (oneway.test).}

\item{minMax}{Whether to use [min,max] instead of [p25,p75] for nonnormal variables. The default is FALSE.}

\item{...}{For compatibility with generic. Ignored.}
}
\value{
A matrix object containing what you see is also invisibly returned. This can be assinged a name and exported via \code{write.csv}.
}
\description{
\code{print} method for the \code{TableOne} class objects created by \code{\link{CreateTableOne}} function.
}
\examples{

## See examples for CreateTableOne and svyCreateTableOne

}
\seealso{
\code{\link{CreateTableOne}}, \code{\link{CreateTableOne}}, \code{\link{summary.TableOne}}
}
\author{
Kazuki Yoshida, Justin Bohn
}
