% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesizer.R
\name{make_synthesizer}
\alias{make_synthesizer}
\alias{make_synthesizer.numeric}
\alias{make_synthesizer.integer}
\alias{make_synthesizer.factor}
\alias{make_synthesizer.character}
\alias{make_synthesizer.data.frame}
\title{Create a function that generates synthetic data}
\usage{
make_synthesizer(y)

\method{make_synthesizer}{numeric}(y)

\method{make_synthesizer}{integer}(y)

\method{make_synthesizer}{factor}(y)

\method{make_synthesizer}{character}(y)

\method{make_synthesizer}{data.frame}(y)
}
\arguments{
\item{y}{\code{[vector|data.frame]} Template data to be synthesized.}
}
\value{
A \code{function} accepting a single integer argument: the number
        of synthesized values or records to return.
}
\description{
Create a function that accepts a non-negative integer \code{n}, and
that returns synthetic data sampled from the emperical (multivariate)
distribution of \code{y}.
}
\examples{
synth <- make_synthesizer(cars$speed)
synth(10)


synth <- make_synthesizer(iris)
synth(6)
synth(150)
synth(250)

}
\seealso{
Other synthesis: 
\code{\link{synthesize}()}
}
\concept{synthesis}
