% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_data-documentation.R
\docType{data}
\name{MBR}
\alias{MBR}
\title{Multiple Birth Rate data by year and race of mother}
\format{
A \code{data.frame} with 110 observations and 8 variables.
\describe{
 \item{year}{The year for which data was was recorded.}
 \item{race}{The racial group of the mothers. One of \code{all} all races; \code{white} 
 non-hispanic whites; \code{black_aa} non Hispanic black / African-American; \code{hisp_lat} 
 Hispanic.}
 \item{births}{Total births for the year and racial group in the United States.}
 \item{twin_births}{Total twin births for the year and racial group in the United States.}
 \item{triplet_more_births}{Total triplet or higher order births for the year and racial group in 
 the United States.}
 \item{MBRate}{The number of live births in all multiple deliveries per 1,000 live births.}
 \item{twinBR}{The number of live births in all twin deliveries per 1,000 live births.}
 \item{twinBR}{The number of live births in all triplet or higher order deliveries per 100,000 
 live births.}
}
}
\source{
\url{http://www.cdc.gov/nchs/nvss/births.htm}
}
\usage{
MBR
}
\description{
A dataset containing multiple birth rate data by race of the mother. Data for all 
races is provided for 1980-2014 and for individual races from 1990-2014.
}
\section{Details}{

\itemize{
 \item{Data for race cateogry \code{"all"} includes races other than white and black and origin 
 not stated.}
 \item{Race and Hispanic origin are reported separately on birth certificates. Persons of Hispanic
 origin may be of any race.}
}
}

\references{
Hamilton, Brady E., et al. "Births: final data for 2014." National Vital Statistics 
Reports 64.12 (2015): 1-64.
}
\keyword{datasets}
