% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showSymbolicQsprayABCXYZ}
\alias{showSymbolicQsprayABCXYZ}
\title{Print a 'symbolicQspray' object}
\usage{
showSymbolicQsprayABCXYZ(
  params,
  vars = c("X", "Y", "Z"),
  quotientBar = " \%//\% ",
  ...
)
}
\arguments{
\item{params}{vector of strings, usually some letters, to denote the
parameters of the polynomial}

\item{vars}{a vector of strings, usually some letters, to denote the
variables of the polynomial}

\item{quotientBar}{a string for the quotient bar between the numerator and
the denominator of a \code{ratioOfQsprays} object, including surrounding
spaces, e.g. \code{" / "}}

\item{...}{arguments other than \code{showRatioOfQsprays} and
\code{showMonomial} passed to \code{\link{showSymbolicQspray}}}
}
\value{
A function which prints \code{symbolicQspray} objects.
}
\description{
Prints a \code{symbolicQspray} object.
}
\note{
This function is built by applying \code{\link{showSymbolicQspray}} to
  \code{\link[ratioOfQsprays]{showRatioOfQspraysXYZ}(params)} and
  \code{\link[qspray]{showMonomialXYZ}(vars)}.
}
\examples{
set.seed(421)
( Qspray <- rSymbolicQspray() )
showSymbolicQsprayABCXYZ(c("a", "b", "c"), c("U", "V"))(Qspray)
}
