% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_string.R
\name{count_string}
\alias{count_string}
\title{String Syllable Counts}
\usage{
count_string(x, ...)
}
\arguments{
\item{x}{A character string.}

\item{\ldots}{ignored}
}
\value{
Returns a vector of integer counts.
}
\description{
Syllable counts for the words in a single string.
}
\examples{
count_string("I like chicken and eggs for breakfast")
count_string(hamlets_soliloquy)
library(stringi)

data.frame(
    word = stri_extract_all_words(stri_trans_tolower(hamlets_soliloquy))[[1]],
    syllables = count_string(hamlets_soliloquy)
)
}
\seealso{
Other syllable.functions: \code{\link{count_vector_by}},
  \code{\link{count_vector}}, \code{\link{sum_string}},
  \code{\link{sum_vector_by}}, \code{\link{sum_vector}},
  \code{\link{tally_both_string}},
  \code{\link{tally_both_vector_by}},
  \code{\link{tally_both_vector}},
  \code{\link{tally_di_string}},
  \code{\link{tally_di_vector_by}},
  \code{\link{tally_di_vector}},
  \code{\link{tally_mono_string}},
  \code{\link{tally_mono_vector_by}},
  \code{\link{tally_mono_vector}},
  \code{\link{tally_poly_string}},
  \code{\link{tally_poly_vector_by}},
  \code{\link{tally_poly_vector}},
  \code{\link{tally_short_string}},
  \code{\link{tally_short_vector_by}},
  \code{\link{tally_short_vector}}
}

