% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{formula_merge}
\alias{formula_merge}
\title{Merge formulas}
\usage{
formula_merge(..., type = "all")
}
\arguments{
\item{...}{formulas to be merged such that there is a single element
on the left hand side and various elements on the right hand side.}

\item{type}{string representing the type of merge to be used.
If \code{type = "all"} then both right hand side and left hand side
elements of the formulas will be merged on the right hand side.
If \code{type = "terms"} then only right hand side elements of the
formulas will be merged on the right hand side.
If \code{type = "var-terms"} then the result is the same as in case
when \code{type = "terms"} but there will be left hand side element
of the first formula on the left hand side of the merged formula.}
}
\value{
This function returns a formula which form depends on 
\code{type} input argument value. See 'Details' for additional information.
}
\description{
This function merges all variables of several formulas
into a single formula.
}
\details{
Merged formulas should have a single element on the left hand
side and voluntary number of elements on the right hand side.
}
\examples{
# Consider three formulas
f1 <- as.formula("y1 ~ x1 + x2")
f2 <- as.formula("y2 ~ x2 + x3")
f3 <- as.formula("y3 ~ y2 + x6")
# Merge these formulas in a various ways
formula_merge(f1, f2, f3, type = "all")
formula_merge(f1, f2, f3, type = "terms")
formula_merge(f1, f2, f3, type = "var-terms")

}
