% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_to_dfr.R
\name{swiss_json_to_dfr}
\alias{swiss_json_to_dfr}
\title{Transform a opendata.swiss national results json into a tibble}
\usage{
swiss_json_to_dfr(votedate = NULL, geolevel = "municipality",
  dataurl = NULL, index = NULL)
}
\arguments{
\item{votedate}{date of the ballot. Default: most recent ballot available. To select multiple ballots use the 'get_swissvotes'-function. Format = YYYYMMDD}

\item{geolevel}{geographical level for which the results should be loaded. options "national", "canton", "district" or "municipality"}

\item{dataurl}{url of the dataset on opendata-swiss}

\item{index}{selection by index of the resource (last published = 1).}
}
\value{
a tibble containing the results
}
\description{
\code{swiss_json_to_dfr} Transforms the json containing the results of a selected federal votedate into a tibble.
}
\examples{

# transform the json of the most recent vote
results <- swiss_json_to_dfr()


# transform the json of a selected votedate

swiss_json_to_dfr(votedate = "2019-02-10")


}
