% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swimplot.R
\name{swimmer_lines}
\alias{swimmer_lines}
\title{Adding lines to a swimmers plot}
\usage{
swimmer_lines(
  df_lines,
  id = "id",
  start = "start",
  end = "end",
  name_linetype = NULL,
  name_col = NULL,
  name_size = NULL,
  name_alpha = NULL,
  ...
)
}
\arguments{
\item{df_lines}{a data frame}

\item{id}{column name for id, default is 'id'}

\item{start}{column name with the line start locations}

\item{end}{column name with the line end locations}

\item{name_linetype}{a column name to map the line type}

\item{name_col}{a column name to map the line colour}

\item{name_size}{a column name to map the line size}

\item{name_alpha}{a column name to map the line transparency}

\item{...}{additional geom_segment() arguments}
}
\value{
a swimmer plot with lines
}
\description{
This function allows you to add lines to a swimmers plot created with \code{\link{swimmer_plot}}
}
\examples{


#Start with a base swimmer plot
swim_plot <-
swimmer_plot(df=ClinicalTrial.Arm,id='id',end='End_trt',name_fill='Arm',col="black",id_order='Arm')


# Then add lines to the plot

swim_plot_with_lines <- swim_plot +
swimmer_lines(df_lines=ClinicalTrial.Response,id='id',start =
'Response_start',end='Response_end',name_col='Response',size=3)


# Add ggplot layers to improve the plot's aesthetic

swim_plot_with_lines +
ggplot2::scale_color_manual(name="Response",values=c("grey20","grey80"))+
ggplot2::scale_fill_manual(name="Treatment",values=c("#e41a1c", "#377eb8","#4daf4a"))+
ggplot2::ylab('Time (Days)')

}
\seealso{
\code{\link{swimmer_plot}} \code{\link{swimmer_points}} \code{\link{swimmer_lines}}  \code{\link{swimmer_points_from_lines}} \code{\link{swimmer_arrows}}
}
