% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surveydata-package.R
\docType{package}
\name{surveydata-package}
\alias{surveydata-package}
\alias{surveydata}
\title{Tools, classes and methods to manipulate survey data.}
\description{
Tools, classes and methods to manipulate survey data.
}
\details{
Surveydata objects have been designed to function with SPSS export data, i.e. the result of an SPSS import,  \code{\link[foreign:read.spss]{foreign::read.spss()}}.  This type of data is contained in a data.frame, with information about the questionnaire text in the \code{variable.labels} attribute.  Surveydata objects keep track of the variable labels, by offering methods for renaming, subsetting, etc.

Coercion functions:
\itemize{
\item \code{\link[=as.surveydata]{as.surveydata()}}
\item \code{\link[=is.surveydata]{is.surveydata()}}
\item \code{\link[=as.data.frame.surveydata]{as.data.frame.surveydata()}}
}

To access and modify attributes:
\itemize{
\item \code{\link[=pattern]{pattern()}}
\item \code{\link[=varlabels]{varlabels()}}
}

To subset or merge surveydata objects:
\itemize{
\item \code{\link[=merge]{merge()}}
\item \code{\link[=Extract]{Extract()}}
\item \code{\link[=cbind.surveydata]{cbind.surveydata()}}
}

To extract question text from varlabels:
\itemize{
\item \code{\link[=question_text]{question_text()}}
\item \code{\link[=question_text_common]{question_text_common()}}
\item \code{\link[=question_text_unique]{question_text_unique()}}
}

To fix common encoding problems:
\itemize{
\item \code{\link[=encToInt]{encToInt()}}
\item \code{\link[=intToEnc]{intToEnc()}}
\item \code{\link[=fix_common_encoding_problems]{fix_common_encoding_problems()}}
}

To clean data:
\itemize{
\item \code{\link[=remove_dont_know]{remove_dont_know()}} to remove "Don't know" responses
\item \code{\link[=remove_all_dont_know]{remove_all_dont_know()}} to remove "Don't know" responses from all questions
\item \code{\link[=fix_levels_01]{fix_levels_01()}} to fix level formatting of all question with Yes/No type answers
}

Miscellaneous tools:
\itemize{
\item \code{\link[=dropout]{dropout()}} to determine questions where respondents drop out
}
}
\examples{
library(surveydata)

# Create surveydata object

sdat <- data.frame(
    id   = 1:4,
    Q1   = c("Yes", "No", "Yes", "Yes"),
    Q4_1 = c(1, 2, 1, 2), 
    Q4_2 = c(3, 4, 4, 3), 
    Q4_3 = c(5, 5, 6, 6), 
    Q10 = factor(c("Male", "Female", "Female", "Male")),
    crossbreak  = c("A", "A", "B", "B"), 
    weight      = c(0.9, 1.1, 0.8, 1.2)
)

varlabels(sdat) <- c(
    "RespID",
    "Question 1", 
    "Question 4: red", "Question 4: green", "Question 4: blue", 
    "Question 10",
    "crossbreak",
    "weight"
  )

sv <- as.surveydata(sdat, renameVarlabels = TRUE)

# Extract specific questions
sv[, "Q1"]
sv[, "Q4"]

# Query attributes
varlabels(sv)
pattern(sv)

# Find unique questions

questions(sv)
which.q(sv, "Q1")
which.q(sv, "Q4")

# Find question text
question_text(sv, "Q1")
question_text(sv, "Q4")

question_text_common(sv, "Q4")
question_text_unique(sv, "Q4")


# Basic operations on a surveydata object, illustrated with the example dataset membersurvey

class(membersurvey)

questions(membersurvey)

which.q(membersurvey, "Q1")
which.q(membersurvey, "Q3")
which.q(membersurvey, c("Q1", "Q3"))

question_text(membersurvey, "Q3")
question_text_unique(membersurvey, "Q3")
question_text_common(membersurvey, "Q3")

# Extracting columns from a surveydata object

head(membersurvey[, "Q1"])
head(membersurvey["Q1"])
head(membersurvey[, "Q3"])
head(membersurvey[, c("Q1", "Q3")])

# Note that the result is always a surveydata object, even if only one column is extracted

head(membersurvey[, "id"])
str(membersurvey[, "id"])

}
\author{
Andrie de Vries \email{apdevries@gmail.com}
}
\keyword{package}
