% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.list.R
\name{print.list}
\alias{print.list}
\title{Print Method for Objects of Class \dQuote{list}}
\usage{
\method{print}{list}(x, method = "pander", file = "", 
  append = FALSE, report.title = NA, table.classes = NA, 
  bootstrap.css = st_options('bootstrap.css'), 
  custom.css = st_options('custom.css'), silent = FALSE, 
  footnote = st_options('footnote'), collapse = 0,
  escape.pipe = st_options('escape.pipe'), \dots)
}
\arguments{
\item{x}{A \emph{summarytools} object, created by one of the four core
functions (\code{\link{freq}}, \code{\link{descr}}, \code{\link{ctable}},
or \code{\link{dfSummary}}).}

\item{method}{Character. One of \dQuote{pander}, \dQuote{viewer}, 
\dQuote{browser}, or \dQuote{render}. Default value for the \code{print()}
method is \dQuote{pander}; for \code{view()}/\code{stview()}, default is
\dQuote{viewer} if session is running in \emph{RStudio}, \dQuote{browser}
otherwise. The main use for \dQuote{render} is in \emph{R Markdown}
documents.}

\item{file}{Character. File name to write output to. Defaults to \dQuote{}.}

\item{append}{Logical. Append output to existing file (specified using the
\emph{file} argument). \code{FALSE} by default.}

\item{report.title}{Character. For \emph{html} reports, this goes into the
\code{<title>} tag. When left to \code{NA} (default), the first line of the
heading section is used (\emph{e.g.}: \dQuote{Data Frame Summary}).}

\item{table.classes}{Character. Additional \emph{html} classes to assign to
output tables. \emph{Bootstrap css} classes can be used. User-defined
classes (see the \emph{custom.css} argument) are also specified here. See
\emph{details} section. \code{NA} by default.}

\item{bootstrap.css}{Logical. When generating an \emph{html} document, 
include the \dQuote{\emph{includes/stylesheets/bootstrap.min.css"}} file
content inside a \code{<style type="text/css">} tag in the document's
\code{<head>}. \code{TRUE} by default. Can be set globally with 
\code{\link{st_options}}.}

\item{custom.css}{Character. Path to a custom \emph{.css} file. Classes
defined in this must also appear in the \code{table.classes} parameter
in order to be applied to the table(s). Can be set globally with
\code{\link{st_options}}. \code{NA} by default.}

\item{silent}{Logical. Set to \code{TRUE} to hide console messages 
(\emph{e.g.}: ignored variables or \code{NaN} to \code{NA}
transformations). \code{FALSE} by default.}

\item{footnote}{Character. Text to display just after \emph{html} output
tables. The default value (\dQuote{\emph{default}}) produces a two-line
footnote indicating the package's name and version, the R version, and
the current date. Has no effect on \emph{ascii} or \emph{markdown}
content. Can contain standard \emph{html} tags. Set to \code{NA} to omit.
Can be set globally with \code{\link{st_options}}.}

\item{collapse}{Numeric. \code{0} by default. Set to \code{1} to make
\code{freq()} sections collapsible (when clicking on the variable name).
Future versions might provide alternate collapsing options.}

\item{escape.pipe}{Logical. Set to \code{TRUE} when \code{style="grid"}
and \code{file} argument is supplied if the intent is to generate a text
file that can be converted to other formats using \emph{Pandoc}. Can be
set globally with \code{\link{st_options}}.}

\item{...}{Additional arguments used to override attributes stored in the
object, or to change formatting via \code{\link[base]{format}} or 
\code{\link[pander]{pander}}. See \emph{Details}.}
}
\description{
Displays a list comprised of summarytools objects created with \code{lapply}.
}
