% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb.R
\name{tb}
\alias{tb}
\title{Convert Summarytools Objects into Tibbles}
\usage{
tb(x, order = 1, na.rm = FALSE, drop.var.col = FALSE)
}
\arguments{
\item{x}{a freq() or descr() output object.}

\item{order}{Integer. Useful for grouped results produced with 
\code{\link{stby}} or \code{dplyr::group_by}. When set to \code{1}
 (default), the ordering is done using the grouping variables first. When
 set to \code{2}, the ordering is first determined by the \code{variable}
 column for \code{\link{descr}} or the column displaying the variable
 values for \code{\link{freq}}. When set to \code{3}, the same ordering
 as with \code{2} is used, but columns are rearranged to reflect this
 sort order.}

\item{na.rm}{Logical. For \code{\link{freq}} objects, remove \code{<NA>} rows
(or \code{(Missing)} rows if \code{NA} values were made explicit with 
\code{forcats::fct_explicit_na()}. Has no effect on \code{\link{descr}} 
objects.}

\item{drop.var.col}{Logical. For \code{\link{descr}} objects, drop the
\code{variable} column. This is possible only when statistics are
produced for a single variable; for multiple variables, this argument
is ignored. \code{FALSE} by default.}
}
\value{
A \code{\link[tibble]{tibble}} which is constructed following the 
\emph{tidy} principles.
}
\description{
Make a tidy dataset out of freq() or descr() outputs
}
\examples{

tb(freq(iris$Species))
tb(descr(iris))

data("tobacco")
tb(stby(tobacco, tobacco$gender, descr))

}
