% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summarytools.R
\name{print.summarytools}
\alias{print.summarytools}
\alias{print}
\alias{view}
\title{Print Method for Objects of Class \code{summarytools}.}
\usage{
\method{print}{summarytools}(x, method = "pander", file = "",
   append = FALSE, report.title = NA, escape.pipe = FALSE,
   html.table.class = NA, custom.css = NA, silent = FALSE,
   footnote = "default", \dots)

view(x, method = "viewer", file = "", append = FALSE,
  report.title = NA, escape.pipe = FALSE, html.table.class = NA,
  custom.css = NA, silent = FALSE, footnote = "default", \dots)
}
\arguments{
\item{x}{A summarytools object that was generated with \code{\link{freq}},
\code{\link{descr}}, \code{\link{ctable}} or \code{\link{dfSummary}}.}

\item{method}{One of \dQuote{pander}, \dQuote{viewer}, \dQuote{browser}, or
\dQuote{render}. For \code{print()}, default is \dQuote{pander}; for
\code{view()}, default is \dQuote{viewer}. If \dQuote{viewer} is used
outside \emph{RStudio}, \dQuote{browser} will be used instead. Use
\dQuote{render} if function is called from an Rmd document.}

\item{file}{File name to write output to. Defaults to \dQuote{}.}

\item{append}{Logical. When \code{file} argument is supplied, this indicates
whether to append output to existing file. \code{FALSE} by default.}

\item{report.title}{For \emph{html} reports, this goes into the
\code{<title>} tag. Defaults to \code{NA}, in which case \code{<title>}
will be generic.}

\item{escape.pipe}{Logical. Set to \code{TRUE} when using
\code{style='grid'} and \code{file} argument is supplied if the intent
is to generate a text file that can be converted to other formats using
\emph{Pandoc}.}

\item{html.table.class}{All \emph{Bootstrap CSS} classes can be used. It also allows
user-defined classes (see custom.css parameter). See \emph{details} section.
\code{NA} by default.}

\item{custom.css}{Path to a user-defined \emph{.css} file. Classes
defined in this file can be used in the \code{html.table.classes}
parameter. \code{NA} by default.}

\item{silent}{Hide console messages (such as ignored variables or \code{NaN}
to \code{NA} transformations).}

\item{footnote}{footnote in \emph{html} output. When set to \dQuote{default},
this is the package name and version, R version, and current date). Has no effect
when \code{method} is \dQuote{pander}. Set to \dQuote{default}, provide your own text,
or set to \code{NA} to omit.}

\item{\dots}{Additional arguments can be used to override parameters stored
as attributes in the object being printed. See \emph{Details} section.}
}
\value{
\code{NULL} when \code{method="pander"}; a file path (returned
  invisibly) when \code{method="viewer"} or \code{method="browser"}. In the
  latter case, the file path is also passed to \code{shell.exec} so the
  document is opened with default Web Browser.
}
\description{
Display \code{summarytools} objects in the console, in Web Browser or in
 \emph{RStudio}'s Viewer, or create formatted output files.
}
\details{
Plain ascii and \emph{rmarkdown} tables are generated via
  \code{\link[pander]{pander}}. See \emph{References} section
  for a list of all available \emph{pander} options.

\emph{Html} tables use \emph{Bootstrap Cascading Style Sheets}.
  To add custom \emph{CSS}, edit the \emph{custom.css} file located in package's
  \emph{includes/stylesheets} directory.

To print objects of class \dQuote{by}, use \code{\link{view}}. This
  function also makes it more practical to generate \emph{html} files (see
  examples).

Default values for \code{html.table.attributes} are as follows:
  \describe{
    \item{freq}{\code{'class="table table-striped table-bordered freq-table"'}}
    \item{ctable}{\code{'class="table table-striped table-bordered cross-table"'}}
    \item{descr}{\code{'class="table table-striped table-bordered desc-table"'}}
    \item{dfSummary}{\code{'class="table table-striped table-bordered"'}}}
When specifying this parameter, you must also state those attributes if you want them to be applied.

The following additional arguments can be used to override
  formatting and other attributes stored in the object to be printed:
   \itemize{
     \item \code{date}
     \item \code{style}
     \item \code{round.digits} (exception: dfSummary objects)
     \item \code{justify}
     \item \code{plain.ascii}
     \item \code{missing}
     \item \code{omit.headings}
     \item \code{split.table}
     \item \code{Dataframe}
     \item \code{Dataframe.label}
     \item \code{Variable}
     \item \code{Variable.label}
     \item \code{Variable.labels} (\code{\link{descr}} objects only)
     \item \code{use.labels} (\code{\link{descr}} objects only)
     \item \code{Data.type}
     \item \code{Subset}
     \item \code{Group}
     \item \code{Weights}
     \item \code{Row.variable} (\code{\link{ctable}} objects only)
     \item \code{Col.variable} (\code{\link{ctable}} objects only)
     \item \code{Row.variable.subset} (\code{\link{ctable}} objects only)
     \item \code{Col.variable.subset} (\code{\link{ctable}} objects only)
     \item \code{Row.variable.label} (\code{\link{ctable}} objects only)
     \item \code{Col.variable.label} (\code{\link{ctable}} objects only)
   }
}
\examples{
  \dontrun{
  data(tobacco)
  view(dfSummary(tobacco))
  }
  data(exams)
  print(freq(exams$gender))
  print(descr(exams), "pander", style = "grid")

}
\references{
\href{http://rstudio.com}{Rstudio}
\href{https://github.com/dcomtois/summarytools}{Summarytools on Github}
\href{http://rapporter.github.io/pander/#general-options}{List of pander options on Github}
\href{http://getbootstrap.com/css/#tables}{Bootstrap Cascading Stylesheets}
}
\seealso{
\code{\link[pander]{pander}}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{methods}
\keyword{print}
