% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reindent.R
\name{find_tokens_to_update}
\alias{find_tokens_to_update}
\title{Find the tokens to update when applying a reference indention}
\usage{
find_tokens_to_update(flattened_pd, target_token)
}
\arguments{
\item{flattened_pd}{A flattened parse table.}

\item{target_token}{The index of the token from which the indention level
should be applied to other tokens.}
}
\description{
Given a target token and a flattened parse table, the token for which the
spacing information needs to be updated are computed. Since indention is
already embedded in the column \code{lag_spaces}, only tokens at the beginning of
a line are of concern.
}
\examples{
style_text("function(a =
  b,
  dd
) {}", scope = "indention")
style_text("function(a,
  b,
  dd
) {}", scope = "indention")
}
\seealso{
apply_ref_indention_one()
}
\keyword{internal}
