% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strvalidator-package.r
\docType{package}
\name{strvalidator-package}
\alias{strvalidator-package}
\title{Process Control and Internal Validation of Forensic STR Kits}
\description{
STR-validator is a free and open source R-package intended for
process control and internal validation of forensic STR DNA typing kit.
Its graphical user interface simplifies the analysis of data exported from
e.g. GeneMapper software, without extensive knowledge about R. It provides 
functions to import, view, edit, and export data. After analysis the
results, generated plots, heat-maps, and data can be saved in projects for
easy access. Currently, analysis modules for stutter, balance, dropout,
mixture, concordance, typing result, precision, pull-up, analytical
thresholds, and drop-in are available. In addition there are functions
to analyse the GeneMapper bins- and panels files. EPG like plots can be
generate from data. STR-validator can greatly increase the speed of
validation by reducing the time and effort needed to analyse the data.
It allows exploration of the characteristics of DNA typing kits according
to ENFSI and SWGDAM recommendations (see references). This facilitates the
implementation of probabilistic interpretation of DNA results.\cr\cr

Effort has been made to assure correct results. Refer to the main website
for a list of functions specifically tested at build time.\cr\cr

Click \code{Index} at the bottom of the page to see a complete list of
functions.\cr\cr

Created and maintained by:\cr
Oskar Hansson, Department of Forensic Biology (NIPH, Norway)\cr\cr

General user information and tutorials:\cr
\url{https://sites.google.com/site/forensicapps/strvalidator}\cr\cr

Facebook user community:\cr
\url{https://www.facebook.com/pages/STR-validator/240891279451450?ref=tn_tnmn}\cr\cr
\url{https://www.facebook.com/groups/strvalidator/}\cr\cr

Please report bugs to:\cr
\url{https://github.com/OskarHansson/strvalidator/issues}\cr\cr

The source code and collaborative community is hosted at GitHub:\cr
\url{https://github.com/OskarHansson/strvalidator}\cr\cr
}
\author{
Oskar Hansson \email{oskar.hansson@fhi.no}
}
\references{
Recommended Minimum Criteria for the Validation of Various Aspects of the DNA Profiling Process
\url{http://www.enfsi.eu/sites/default/files/documents/minimum_validation_guidelines_in_dna_profiling_-_v2010_0.pdf}
Validation Guidelines for Forensic DNA Analysis Methods (2012)
\url{http://media.wix.com/ugd/4344b0_cbc27d16dcb64fd88cb36ab2a2a25e4c.pdf}
}
\keyword{package}

