% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculatePullup.r
\name{calculatePullup}
\alias{calculatePullup}
\title{Calculate Spectral Pull-up}
\usage{
calculatePullup(data, ref, pullup.range = 6, block.range = 12,
  ol.rm = FALSE, ignore.case = TRUE, word = FALSE, discard = FALSE,
  limit = 1, debug = FALSE)
}
\arguments{
\item{data}{a data frame containing at least 'Sample.Name', 'Marker', 'Height',
'Allele', 'Dye', 'Data.Point' and 'Size'.}

\item{ref}{a data frame containing at least
'Sample.Name', 'Marker', 'Allele'.}

\item{pullup.range}{numeric to set the analysis window to look for pull-up
peaks (known allele data point +- pullup.range/2)}

\item{block.range}{numeric to set blocking range to check for known allele overlap
(known allele data point +- block.range/2).}

\item{ol.rm}{logical TRUE if off-ladder peaks should be excluded from analysis.
Default is FALSE to include off-ladder peaks.}

\item{ignore.case}{logical indicating if sample matching should ignore case.}

\item{word}{logical indicating if word boundaries should be added before sample matching.}

\item{discard}{logical TRUE if known alleles with no detected pull-up should
be discarded from the result. Default is FALSE to include alleles not causing pull-up.}

\item{limit}{numeric remove ratios > limit from the result. Default is 1 to remove 
pull-up peaks that are higher than the source peak and hence likely not a real pull-up.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with with columns 'Sample.Name', 'Marker', 'Dye',
'Allele', 'Height', 'Size', 'Data.Point', 'P.Marker', 'P.Dye', 'P.Allele',
'P.Height', 'P.Size', 'P.Data.Point', 'Delta', 'Ratio'.
}
\description{
Calculates possible pull-up peaks.
}
\details{
Calculates possible pull-up (aka. bleed-through) peaks in a dataset.
Known alleles are identified and the analysis window range is marked.
If the blocking range of known alleles overlap, they are excluded from the
analysis. Pull-up peaks within the data point analysis window, around
known alleles, are identified, the data point difference, and the ratio
is calculated.
Off-ladder ('OL') alleles are included by default but can be excluded.
All known peaks included in the analysis are by default written to the
result even if they did not cause any pull-up. These rows can be discarded
from the result.
}

