% Generated by roxygen2 (4.0.1): do not edit by hand
\name{saveObject}
\alias{saveObject}
\title{Save object}
\usage{
saveObject(name = NULL, object, parent = NULL, suggest = "",
  env = parent.frame(), remove = NULL, debug = FALSE)
}
\arguments{
\item{name}{character giving the name of the object to save.
If NULL a dialogue asks for a name.}

\item{object}{object to save.}

\item{parent}{object specifying the parent GUI object to center the message box.}

\item{suggest}{character string for a suggested name for the object to save/re-name.}

\item{env}{environment in wich to save and search for existing objects.}

\item{remove}{character string for a named object to remove (e.g. the original object if re-naming).}

\item{debug}{logical indicating printing debug information.}
}
\value{
logical TRUE if object was saved FALSE if not.
}
\description{
Saves an object in the specified environment.
}
\details{
Saves an object with the given name in the specified environment
if it does not exist. If the object exist a message box ask if the object
should be overwritten. The function can also be used to re-name if 'name'
is not provided (NULL). The 'suggest' provides a suggested name for the
object to re-name.
}
\keyword{internal}

