% Generated by roxygen2 (4.0.1): do not edit by hand
\name{calculateCapillary}
\alias{calculateCapillary}
\title{Calculate capillary balance}
\usage{
calculateCapillary(samplesTable, plotTable, sq = 0, run = "",
  debug = FALSE)
}
\arguments{
\item{samplesTable}{data frame containing at least the columns
'Sample.File', 'Sample.Name', 'Size.Standard', 'Instrument.Type',
'Instrument.ID', 'Cap', 'Well', and 'SQ'.}

\item{plotTable}{data frame containing at least the columns
'Sample.File.Name', 'Size', and 'Height'.}

\item{sq}{numeric threshold for 'Sizing Quality' (SQ).}

\item{run}{character string for run name.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with with columns 'Instrument', 'Instrument.ID', 'Run',
'Mean.Height', 'SQ', 'Injection', 'Capillary', 'Well', 'Comment'.
}
\description{
\code{calculateCapillary} calculates the ILS inter capillary balance.
}
\details{
Calculates the inter capillary balance for the internal lane standard (ILS).
Require information from both the 'SamplesTable' and the 'PlotTable'.
}

