% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{stri_rank}
\alias{stri_rank}
\title{Ranking}
\usage{
stri_rank(str, ..., opts_collator = NULL)
}
\arguments{
\item{str}{a character vector}

\item{...}{additional settings for \code{opts_collator}}

\item{opts_collator}{a named list with \pkg{ICU} Collator's options,
see \code{\link{stri_opts_collator}}, \code{NULL}
for default collation options}
}
\value{
The result is a vector of ranks corresponding to each
string in \code{str}.
}
\description{
This function ranks each string in a character vector according to a
locale-dependent lexicographic order.
It is a portable replacement for the base \code{xtfrm} function.
}
\details{
Missing values result in missing ranks and tied observations receive
the same ranks (based on min).

For more information on \pkg{ICU}'s Collator and how to tune it up
in \pkg{stringi}, refer to \code{\link{stri_opts_collator}}.
}
\examples{
stri_rank(c('hladny', 'chladny'), locale='pl_PL')
stri_rank(c('hladny', 'chladny'), locale='sk_SK')

stri_rank("a" \%s+\% c(1, 100, 2, 101, 11, 10))  # lexicographic order
stri_rank("a" \%s+\% c(1, 100, 2, 101, 11, 10), numeric=TRUE)

# Ordering a data frame with respect to two criteria:
X <- data.frame(a=c("b", NA, "b", "b", NA, "a", "a", "c"), b=runif(8))
X[order(stri_rank(X$a), X$b), ]

}
\references{
\emph{Collation} - ICU User Guide,
\url{http://userguide.icu-project.org/collation}
}
\seealso{
Other locale_sensitive: 
\code{\link{\%s<\%}()},
\code{\link{about_locale}},
\code{\link{about_search_boundaries}},
\code{\link{about_search_coll}},
\code{\link{stri_compare}()},
\code{\link{stri_count_boundaries}()},
\code{\link{stri_duplicated}()},
\code{\link{stri_enc_detect2}()},
\code{\link{stri_extract_all_boundaries}()},
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_opts_collator}()},
\code{\link{stri_order}()},
\code{\link{stri_sort_key}()},
\code{\link{stri_sort}()},
\code{\link{stri_split_boundaries}()},
\code{\link{stri_trans_tolower}()},
\code{\link{stri_unique}()},
\code{\link{stri_wrap}()}
}
\concept{locale_sensitive}
