% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding_conversion.R
\name{stri_enc_toutf32}
\alias{stri_enc_toutf32}
\title{Convert Strings To UTF-32}
\usage{
stri_enc_toutf32(str)
}
\arguments{
\item{str}{a character vector (or an object coercible to)
to be converted}
}
\value{
Returns a list of integer vectors.
Missing values are converted to \code{NULL}s.
}
\description{
UTF-32 is a 32-bit encoding where each Unicode code point
corresponds to exactly one integer value.
This function converts a character vector to a list
of integer vectors so that, e.g.,
individual code points may be easily accessed, changed, etc.
}
\details{
See \code{\link{stri_enc_fromutf32}} for a dual operation.

This function is roughly equivalent to a vectorized call
to \code{\link{utf8ToInt}(enc2utf8(str))}.
If you want a list of raw vectors on output,
use \code{\link{stri_encode}}.

Unlike \code{utf8ToInt}, if ill-formed UTF-8 byte sequences are detected,
a corresponding element is set to NULL and a warning is generated.
To deal with such issues, use, e.g., \code{\link{stri_enc_toutf8}}.
}
\seealso{
Other encoding_conversion: 
\code{\link{about_encoding}},
\code{\link{stri_enc_fromutf32}()},
\code{\link{stri_enc_toascii}()},
\code{\link{stri_enc_tonative}()},
\code{\link{stri_enc_toutf8}()},
\code{\link{stri_encode}()}
}
\concept{encoding_conversion}
