% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{printable_ascii}
\alias{printable_ascii}
\title{Detect the presence of non-printable or non-ascii characters}
\usage{
printable_ascii(x)
}
\arguments{
\item{x}{a \code{character} vector}
}
\value{
A \code{logical} indicating which elements consist solely of printable ASCII characters.
}
\description{
Detect the presence of non-printable or non-ascii characters
}
\details{
Printable ASCII characters consist of space, \code{A-Z}, \code{a-z}, \code{0-9} and the characters

\code{! "" # $ \% & ' ( ) * + , . / : ; < = > ? @ [ ] \\ ^ _ ` { | } ~ -} 

Note that this excludes tab (as it is a control character).
}
\examples{
# define o-umlaut
ouml <- intToUtf8("0x00F6")
x <- c("Motorhead", paste0("Mot",ouml,"rhead"))
# second element contains a non-ascii character
printable_ascii(x)

# Control characters (like carriage return) are also excluded
printable_ascii("abc\\r")


}

