% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stremr-package.R
\docType{data}
\name{OdataNoCENS}
\alias{OdataNoCENS}
\title{An example of a dataset in long format with random monitoring and no right censoring.}
\format{A data frame with 1,000 observations and variables:
\describe{
  \item{ID}{Unique subject identifier}
  \item{CVD}{Baseline confounder (time invariant)}
  \item{t}{Interger for current time period, range 0-16}
  \item{lastNat1}{Time since last monitoring event, set to 0 when N[t-1]=0 and then added one for each new period where N[t] is 0.}
  \item{highA1c}{Time-varying confounder}
  \item{TI}{Binary exposure variable}
  \item{C}{Administrative censoring indicator, always set to 0 unless the end of study is reached (t==16)}
  \item{N}{The indicator of being monitored (having a visit)}
  \item{Y.tplus1}{Binary outcome at t}
}}
\usage{
data(OdataNoCENS)
}
\description{
Simulated dataset containing 1,000 i.i.d. observations organized in long format as person-time rows.
The binary exposure is \code{TI} and binary outcome is \code{Y.tplus1}. See /tests/ for R code that generated this data.
}
\keyword{datasets}

