% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSAggregate_Window.R
\name{DSAggregate_Window}
\alias{DSAggregate_Window}
\title{Sliding Window (Data Stream Operator)}
\usage{
DSAggregate_Window(horizon = 100, lambda = 0)
}
\arguments{
\item{horizon}{the window length.}

\item{lambda}{decay factor damped window model. \code{lambda = 0} means no
dampening.}
}
\value{
An object of class \code{DSAggregate_Window} (subclass of \link{DSAggregate}).
}
\description{
Implements a sliding window data stream operator which keeps a fixed amount
(window length) of the most recent data points of the stream.
}
\details{
If \code{lambda} is greater than 0 then the weight uses a damped window
model (Zhu and Shasha, 2002).  The weight for points in the window follows
\eqn{2^(-lambda*t)} where \eqn{t} is the age of the point.
}
\examples{
set.seed(1500)

## Example 1: Basic use
stream <- DSD_Gaussians(k = 3, d = 2, noise = 0.05)

window <- DSAggregate_Window(horizon = 10)
window

# update with only two points. The window is mostly empty (NA)
update(window, stream, 2)
get_points(window)

# get weights and window as a single data.frame
get_model(window)

# update window
update(window, stream, 100)
get_points(window)

## Example 2: Implement a classifier over a sliding window
window <- DSAggregate_Window(horizon = 100)

update(window, stream, 1000)

# train the classifier on the window
library(rpart)
tree <- rpart(`.class` ~ ., data = get_points(window))
tree

# predict the class for new points from the stream
new_points <- get_points(stream, n = 100, info = FALSE)
pred <- predict(tree, new_points)
plot(new_points, col = pred)
}
\references{
Zhu, Y. and Shasha, D. (2002). StatStream: Statistical
Monitoring of Thousands of Data Streams in Real Time, Intl. Conference of
Very Large Data Bases (VLDB'02).
}
\seealso{
Other DSAggregate: 
\code{\link{DSAggregate_Sample}()},
\code{\link{DSAggregate}()}
}
\author{
Michael Hahsler
}
\concept{DSAggregate}
