% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_stratify.R
\name{split_pilot_set}
\alias{split_pilot_set}
\title{Split data into pilot and analysis sets}
\usage{
split_pilot_set(data, treat, pilot_fraction = 0.1, pilot_sample = NULL)
}
\arguments{
\item{data}{\code{data.frame} with observations as rows, features as columns}

\item{treat}{string giving the name of column designating treatment
assignment}

\item{pilot_fraction}{numeric between 0 and 1 giving the proportion of
controls to be allotted for building the prognostic score (default = 0.1)}

\item{pilot_sample}{a data.frame of held aside samples for building
prognostic score model.}
}
\value{
a list with analaysis_set and pilot_set
}
\description{
Exported for the convenience of the user, although in practice this process
is almost always done using \code{\link{auto_stratify}}.  Given a data set
and some parameters about how to split the data, this function partitions the
data accordingly and returns the partitioned data as a list containing the
\code{analysis_set} and \code{pilot_set}.
}
\examples{
  dat <- make_sample_data()
  splt <- split_pilot_set(dat, "treat", 0.2)
  a.strat <- auto_stratify(splt$analysis_set, "treat", outcome ~ X1, pilot_sample = splt$pilot_set)
}
