% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strata_object_constructors.R
\name{new_manual_strata}
\alias{new_manual_strata}
\title{New Manual Strata}
\usage{
new_manual_strata(treat = character(), covariates = character(),
  analysis_set = data.frame(), call = call(),
  issue_table = data.frame(), strata_table = data.frame())
}
\arguments{
\item{treat}{a string giving the name of the column where treatment
information is stored}

\item{covariates}{a character vector with the names of the categorical
columns on which to stratify}

\item{analysis_set}{the data set which will be stratified}

\item{call}{the call to \code{auto_stratify} used to generate this object}

\item{issue_table}{a table of each stratum and potential issues of size and
treat:control balance}

\item{strata_table}{a table of each stratum and the covariate bin this
corresponds to}
}
\value{
a basic \code{manual_strata} object
}
\description{
Basic constructor for an \code{manual_strata} object. These objects hold all
the information associated with a dataset that has been stratified via
\code{\link{manual_stratify}}.  This object may be passed to
\code{\link{strata_match}} to be matched or it may be unpacked by the user to be
matched by other means.
}
