% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maverickRun.R
\name{maverickRun}
\alias{maverickRun}
\title{Run MavericK}
\usage{
maverickRun(g, params = NULL, label = "MavericK_files",
  data_fname = "data.txt", param_fname = "parameters.txt")
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{params}{a list specifying parameters for MavericK. All parameters are 
available and can be specified by partial matching. The function will automatically 
specify parameters related to data formatting (data, headerRow_on, 
missingData, ploidy, ploidyCol_on, popCol_on), so those will be ignored. 
For a full list of available parameters and their definitions, see the 
MavericK documentation distributed with the program.}

\item{label}{folder where input and output files will be written to.}

\item{data_fname}{file name of data input file.}

\item{param_fname}{file name of parameters file.}
}
\description{
Run MavericK clustering algorithm
}
\note{
MavericK is not included with \code{strataG} and must be downloaded 
  separately. It can be obtained from \url{http://www.bobverity.com/}. 
  Additionally, it must be installed such that it can be run from 
  the command line in the current working directory. See the vignette 
  for \code{external.programs} for OS-specific installation instructions.
}
\references{
Robert Verity and Richard Nichols. (2016) Estimating the number of 
subpopulations (K) in structured populations. Genetics \cr\cr
Robert Verity and Richard Nichols. (2016) Documentation for MavericK 
software: Version 1.0
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
