% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clumpp.R
\name{clumpp}
\alias{clumpp}
\title{Run CLUMPP}
\usage{
clumpp(sr, k, align.algorithm = "greedy", sim.stat = "g",
  greedy.option = "ran.order", repeats = 100, order.by.run = 0,
  label = NULL, delete.files = TRUE)
}
\arguments{
\item{sr}{result from \code{\link{structure}} or folder name containing 
STRUCTURE output files.}

\item{k}{choice of \emph{k} in \code{sr} to combine.}

\item{align.algorithm}{algorithm to be used for aligning the runs. Can be 
"full.search", "greedy", or "large.k".}

\item{sim.stat}{pairwise matrix similarity statistic to be used. Can be 
"g" or "g.prime".}

\item{greedy.option}{input order of runs to be tested. Required if 
\code{align.algorithm} is "greedy" or "large.k". Valid choices are:
\tabular{ll}{
  \code{all} \tab test all possible input orders of runs (note that this 
    option increases the run-time sub-stantially unless R is small).\cr
  \code{ran.order} \tab test a specified number of random input orders of 
    runs set by the \code{repeats} parameter.\cr
}}

\item{repeats}{the number of input orders of runs to be tested. Only used if 
\code{align.algorithm} is "greedy" or "large.k", and \code{greedy.option} 
  is "ran.order".}

\item{order.by.run}{permute the clusters according to the cluster order of 
a specific run. Set this parameter to a number from 1 to the number of 
runs in \code{sr}.}

\item{label}{label to use for input and output files.}

\item{delete.files}{logical. Delete all files when CLUMPP is finished?}
}
\description{
Run CLUMPP to aggregate multiple STRUCTURE runs.
}
\note{
CLUMPP is not included with \code{strataG} and must be downloaded 
  separately. Additionally, it must be installed such that it can be run from 
  the command line in the current working directory. See the vignette 
  for \code{external.programs}.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Mattias Jakobsson and Noah A. Rosenberg. 2007. CLUMPP: a cluster 
  matching and permutation program for dealing with label switching and 
  multimodality in analysis of population structure. 
  Bioinformatics 23(14):1801-1806. Available at 
  \url{http://web.stanford.edu/group/rosenberglab/clumppDownload.html}
}
\seealso{
\code{\link{structure}}
}

