% Generated by roxygen2 (4.0.2): do not edit by hand
\name{label.haplotypes}
\alias{label.haplotypes}
\alias{label.haplotypes.default}
\alias{label.haplotypes.gtypes}
\title{Find and label haplotypes}
\usage{
label.haplotypes(x, prefix = NULL, ignore.gaps = FALSE)

\method{label.haplotypes}{default}(x, prefix = NULL, ignore.gaps = FALSE)

\method{label.haplotypes}{gtypes}(x, ...)
}
\arguments{
\item{x}{list of DNA sequences or a \code{\link{gtypes}} object.}

\item{prefix}{a character string giving prefix to be applied to numbered haplotypes.
If NULL, haplotypes will be labeled with first label from original sequences.}

\item{ignore.gaps}{logical. Remove sites with gaps when comparing sequences?}

\item{...}{Further arguments to be passed to \code{label.haplotypes.default}.}
}
\value{
List of haplotypes and assignmnents or gtypes object with new haplotypes.
}
\description{
Identify and group sequences that share the same haplotype.
}
\note{
If any sequences contain missing data (N's), a more rigorous matching algorithm is
  conducted and can take longer, especially if there are many samples or long sequences.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

