% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{final.resamp}
\alias{final.resamp}
\title{Final re-sampling step in Bayesian Melding using IMIS.}
\usage{
final.resamp(K, B1, H.new, H.k, log.like, d.keep, prior, h.mu, h.sig, nrisk,
  ndeath, age, B = 400, theta.dim = 9)
}
\arguments{
\item{K}{The number of iterations of the importance sampling stage.}

\item{B1}{Sample size at the importance sampling stage multiplied by the number of local optimums.}

\item{H.new}{A matrix with dimensions ((B * d.keep) * 9) containing the B*d.keep inputs drawn from the multivariate gaussians.}

\item{H.k}{A matrix containing the prior plus new inputs from the multivariate gaussians.}

\item{log.like}{A vector of log-likelihoods corresponding to each row of H.k.}

\item{d.keep}{The number of local optimums found in the optimizer step.}

\item{prior}{A matrix containing the prior.}

\item{h.mu}{A (d.keep * 9) matrix containing the results of the optimizer step.}

\item{h.sig}{An array containing the covariance matrix for each row of h.mu.}

\item{nrisk}{A vector containing the number of persons at risk in each age group.}

\item{ndeath}{A vector containing the number of deaths in each age group.}

\item{age}{A vector containing the ages at which each age interval begins.}

\item{B}{Sample size at the importance sampling stage.}

\item{theta.dim}{The number of columns of the prior matrix.}
}
\value{
\item{H.new}{A (B * theta.dim) matrix containing the posterior distribution for each parameter.}
\item{vwts}{A vector containing the variance of the rescaled weights at each IMIS iteration}
\item{ewts}{A vector containing the entropy of the rescaled weights at each IMIS iteration.}
\item{mwts}{A vector containing the maximum of the rescaled weights at each IMIS iteration.}
\item{nup}{A vector containing the expected number of unique points at each IMIS iteration.}
\item{frac.up}{A vector containing the proportion of unique points in the final resample at each IMIS iteration.}
\item{wts.k}{A vector containing the importance weights for the final iteration.}
\item{mwt.case}{The maximum weight value and associated case.}
}
\description{
Performs the final re-sampling step in the Bayesian Melding with IMIS procedure for the nine adapted Heligman-Pollard parameters.
}
\note{
The function \link{HP.mod} performs this along with all other steps in a single function.
The algorithm ends when the expected fraction of unique points in the resample is at least 1 ??? 1/e = 0.632
}
\references{
Heligman, L. and Pollard, J.H. (1980) The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.

Poole, D. and Raftery, A. (2000). Inference for Deterministic Simulation Models: The Bayesian Melding Approach. Journal of the American Statistical Association 95:1244–1255.

Raftery, A. and Bao, L. (2009). Estimating and Projecting Trends in HIV/AIDS Generalized Epidemics Using Incremental Mixture Importance Sampling. Technical Report 560, Department of Statistics, University of Washington.

Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\seealso{
\link{mod} \link{ll.binom} \link{dens.prior} \link{var.rwts} \link{entropy.wts} \link{expt.upts}
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
\keyword{resampling}
