% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.pri.start.R
\name{HP.pri.start}
\alias{HP.pri.start}
\title{Estimation of starting values for priors of the Heligman-Pollard model.}
\usage{
HP.pri.start(Si.qx, Prop.risk, Life.qx, age, rg = 0.25,
  control = nls.lm.control(maxiter = 100))
}
\arguments{
\item{Si.qx}{A vector of the same length as "age" containing the total mortality rates by age (qx).}

\item{Prop.risk}{A vector of the same length as "age" containing the proportion of death animals identified as death by external effects (other different than natural mortality).}

\item{Life.qx}{Mortality vector qx form life table created with \link{life.tab}.}

\item{age}{A vector containing the ages at which each age interval begins.}

\item{rg}{The variation of the range at which the mean prior values will be multiplied to calculate low and high limits.}

\item{control}{Allow the user to set some characteristics Levenberg-Marquardt nonlinear least squares algorithm implemented in \link{nls.lm}. see \link{nls.lm.control}}
}
\value{
A dataframe with low, high and mean starting values for priors, to be used for fitting a adapted 9-parametres Heligman-Pollard model
}
\description{
Estimates starting values for the priors of the modified 9-parameter Heligman-Pollard model from mortality rates by age and proportion of individuals death from non natural causes.
}
\references{
Heligman, L. and Pollard, J.H. (1980). The Age Pattern of Mortality. Journal of the Institute of Actuaries 107:49–80.

Moré, J.J. (1978). The Levenberg-Marquardt algorithm: implementation and theory, in: Lecture Notes in Mathematics 630: Numerical Analysis, G.A. Watson (Ed.), Springer-Verlag: Berlin, pp. 105-116.
}
\seealso{
\link{HP.priors} \link{HP.mod} \link{nlsLM} \link{life.tab}
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
\keyword{priors}
