% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{m2d}
\alias{m2d}
\title{Matrix to Data-Frame}
\usage{
m2d(m, col = 2, stringsAsFactors = FALSE, check = TRUE)
}
\arguments{
\item{m}{matrix}

\item{col}{numeric vector of length 1 that is equal to either 0, 1, or 2. \code{col}
specifies what dimension from \code{m} should be the columns of the returned data.frame.
If \code{col = 2}, then the columns of \code{m} (i.e., dimension 2) are the columns
of the returned data.frame. If \code{col = 1}, then the rows of \code{m}
(i.e., dimension 1) are the columns of the returned data.frame. If \code{col = 0},
neither of the \code{m} dimensions are the columns and instead the matrix is
expanded by \code{reshape::melt.array} such that in the returned data.frame
the first column is \code{rownames(m)}, the second column is \code{colnames(m},
and the third column is the elements of \code{m}. If any \code{dimnames(m)} are
NULL, then they are replaced with the positions of the dimensions.}

\item{stringsAsFactors}{logical vector of length 1 specifying whether any resulting
character columns in the return object should be factors. If \code{m} is a
character matrix and \code{stringsAsFactors} = TRUE, then all columns in the
returned data.frame will be factors. If \code{col} = 0 and \code{stringsAsFactors}
= TRUE, then the first two columns in the returned data.frame specifying
\code{dimnames(m)} will be factors.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{m} is a matrix.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
data.frame with rownames and colnames specified by \code{dimnames(m)}
and \code{col}. If \code{col = 0}, then the rownames are default (i.e., "1","2","3", etc.)
and the colnames are the following: the first two columns are \code{names(dimnames(m))}
(if NULL they are "rownames" and "colnames", respectively) and the third is
"element".
}
\description{
\code{m2d} converts a matrix to a data.frame. The benefit of \code{m2d} over
\code{as.data.frame.matrix} is that it provides the \code{col} argument, which
allows the columns of the data.frame to be the columns of the matrix (i.e.,
\code{col = 2}), the rows of the matrix (i.e., \code{col = 1}), or the expanded
matrix (i.e., \code{col = 0}).
}
\examples{
mtcars2 <- as.matrix(mtcars, rownames.force = TRUE) # to make sure dimnames stay in the example
m2d(mtcars2) # default
m2d(m = mtcars2, col = 1) # data.frame columns are matrix rownames
m2d(m = mtcars2, col = 0) # data.frame columns are the entire matrix
mat <- cbind(lower = letters, upper = LETTERS)
m2d(mat)
m2d(mat, stringsAsFactors = TRUE)
m2d(mat, col = 0)
m2d(mat, col = 0, stringsAsFactors = TRUE)
}
