% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_prob.R
\name{p_prob}
\alias{p_prob}
\title{Proportional (probability) distribution}
\usage{
p_prob(n,  p_ratio = 20)
}
\arguments{
\item{n}{a number of data points.}

\item{p_ratio}{the smaller of the
terms of specified proportional ratios. For instance, for a
\code{30:70} ratio, \code{p_ratio} is equal to \code{30}.
Default value is set as
\code{20}. Valid \code{p_ratio} values
are: (\code{5, 10, 20, 30, 40}).}
}
\value{
Returns a dataframe with
a probability field.
}
\description{
Generates an \code{n} probability
values in accordance with a specified
proportional ratios.
}
\details{
Proportional ratios are used to divide the
area under curve (auc) of an exponential function
such that for any given percentage ratios \code{a:b}, the
auc is divided into \code{b:a}.
}
\examples{
p_prob(n = 15,  p_ratio = 20)
}
