% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route.R
\name{route}
\alias{route}
\title{Plan routes on the transport network}
\usage{
route(from = NULL, to = NULL, l = NULL,
  route_fun = route_cyclestreet, n_print = 10, list_output = FALSE,
  ...)
}
\arguments{
\item{from}{An object representing origins
(if lines are provided as the first argument, from is assigned to \code{l})}

\item{to}{An object representing destinations}

\item{l}{Only needed if from and to are empty, in which case this
should be a spatial object representing desire lines}

\item{route_fun}{A routing function to be used for converting the straight lines to routes
\code{\link[=od2line]{od2line()}}}

\item{n_print}{A number specifying how frequently progress updates
should be shown}

\item{list_output}{If FALSE (default) assumes SpatialLinesDataFrame output. Set to TRUE to save output as a list.}

\item{...}{Arguments passed to the routing function, e.g. \code{\link[=route_cyclestreet]{route_cyclestreet()}}}
}
\description{
Takes origins and destinations, finds the optimal routes between them
and returns the result as a spatial (sf or sp) object.
The definition of optimal depends on the routing function used
}
\examples{
\dontrun{
from <- "Leek, UK"
to <- "Hereford, UK"
route_leek_to_hereford <- route(from, to)
route(cents_sf[1:3, ], cents_sf[2:4, ]) # sf points
route(flowlines_sf[2:4, ]) # lines
}
}
