% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_segment}
\alias{line_segment}
\title{Divide SpatialLines dataset into regular segments}
\usage{
line_segment(l, n_segments, segment_length = NA)
}
\arguments{
\item{l}{A SpatialLinesDataFrame}

\item{n_segments}{The number of segments to divide the line into}

\item{segment_length}{The approximate length of segments in the output (overides n_segments if set)}
}
\description{
Divide SpatialLines dataset into regular segments
}
\examples{
data(routes_fast)
l = routes_fast[2,]
l_seg2 = line_segment(l = l, n_segments = 2)
plot(l_seg2, col = l_seg2$group, lwd = 50)
l_seg5 = line_segment(l = l, n_segments = 5)
plot(l_seg5, col = l_seg5$group, lwd = 30, add = TRUE)
l_seg100m = line_segment(l = l, segment_length = 100)
plot(l_seg100m, col = l_seg100m$group, lwd = 10, add = TRUE)
plot(l, col = "white", add = TRUE)
line_segment(l = l, segment_length = 100)
}
